<?php
namespace Newland\Toubiz\Api\Service\Sisag\ObjectAdapter;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\Toubiz\Api\ObjectAdapter\AbstractObjectAdapter;
use Newland\Toubiz\Api\ObjectAdapter\RegionAdapterInterface;

/**
 * Region object adapter.
 *
 * Describes a region containing slopes and transportation facilities.
 */
class RegionAdapter extends AbstractObjectAdapter implements RegionAdapterInterface
{
    /**
     * @return string
     */
    public function getExternalId()
    {
        return (integer)$this->object['id'];
    }

    /**
     * @return string
     */
    public function getName()
    {
        return (string)$this->object->NAME;
    }
}
