<?php
namespace Newland\Toubiz\Api\Service;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

/**
 * Abstract service class.
 */
abstract class AbstractService
{
    /**
     * Abstract constant, must be set in concrete classes.
     *
     * @var string Base URI for requests.
     */
    const BASE_URI = '';

    /**
     * @var string The API key matching the client name.
     */
    protected $apiKey;

    /**
     * @var \GuzzleHttp\Client Client for requests.
     */
    protected $httpClient;

    /**
     * @var string The client name to fetch data for.
     */
    protected $clientName;

    /**
     * Class constructor.
     *
     * @api
     * @return void
     */
    public function __construct()
    {
        if (empty(static::BASE_URI)) {
            throw new \InvalidArgumentException('BASE_URI must be declared but is not!');
        }

        $this->httpClient = new \GuzzleHttp\Client(['base_uri' => static::BASE_URI]);
    }

    /**
     * Sets the client name.
     *
     * @api
     * @param string $clientName
     * @return void
     */
    public function setClientName($clientName)
    {
        $this->clientName = $clientName;
    }

    /**
     * Sets the api key.
     *
     * @api
     * @param string $apiKey
     * @return void
     */
    public function setApiKey($apiKey)
    {
        $this->apiKey = $apiKey;
    }
}
