# Toubiz API package

Provides functionality to connect to the Toubiz API's.

## Usage

```
use Newland\Toubiz\Api\Repository\EventRepository;
use Newland\Toubiz\Api\Service\ServiceFactory;

// Get API client for "old" toubiz.
$service = ServiceFactory::get('legacy');

// Set credentials for api calls.
$service->setClientName('foo');
$service->setApiKey('0000');

/*
 * Instantiate event repository for fetching events
 * through the given service.
 */
$repository = new EventRepository($service);

// Alternative way if you don't pass a service to the class constructor.
$repository->setService($service);

// Fetch all active events.
$eventList = $eventRepository->findAllActiveEvents();
```
