<?php
namespace Newland\Toubiz\Api\Service;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

/**
 * Abstract service version class.
 */
abstract class AbstractVersionedService
{
    /**
     * Abstract constant, must be set in concrete classes.
     *
     * @var string Base URI for requests.
     */
    const BASE_URI = '';

    /**
     * @var string The API key matching the client name.
     */
    protected $apiKey;

    /**
     * @var \GuzzleHttp\Client Client for requests.
     */
    protected $httpClient;

    /**
     * @var string The client name to fetch data for.
     */
    protected $clientName;

    /**
     * Class constructor.
     *
     * @api
     * @return void
     */
    public function __construct()
    {
        if (empty(static::BASE_URI)) {
            throw new \InvalidArgumentException('BASE_URI must be declared but is not!');
        }

        $this->httpClient = new \GuzzleHttp\Client(['base_uri' => static::BASE_URI]);
    }

    /**
     * Sets the client name.
     *
     * @api
     * @param string $clientName
     * @return void
     */
    public function setClientName($clientName)
    {
        $this->clientName = $clientName;
    }

    /**
     * Sets the api key.
     *
     * @api
     * @param string $apiKey
     * @return void
     */
    public function setApiKey($apiKey)
    {
        $this->apiKey = $apiKey;
    }

    /**
     * Fetch a list of active events.
     *
     * Active events are events that are published
     * and have not already ended.
     *
     * @api
     * @todo response annotation
     */
    abstract public function fetchActiveEvents();

    /**
     * Fetch details of a given event.
     *
     * As fetchActiveEvents() may not give all event
     * details, this method must be implemented to fully
     * fetch event details and relations.
     *
     * @api
     * @param string $identifier Event record identifier from API
     * @todo respose annotation
     */
    abstract public function fetchEventDetails(string $identifier);
}
