<?php
namespace Newland\Toubiz\Api\Repository;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

/**
 * Abstract repository.
 *
 * Utilizes the strategy pattern to fetch data from
 * the given service version implementation.
 *
 * @todo exception thrown from null service
 */
abstract class AbstractRepository
{
    /**
     * @todo annotate
     */
    protected $service;

    /**
     * @todo annotate
     */
    public function __construct($service = null)
    {
        if ($service) {
            $this->setService($service);
        }
    }

    /**
     * Set the api service.
     *
     * @todo type hint
     * @todo param annotation
     * @return void
     */
    public function setService($service)
    {
        $this->service = $service;
    }
}
