<?php
namespace Newland\Toubiz\Api\Service;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

/**
 * Service factory.
 *
 * Instantiates the correct service version
 * based on the given version number.
 */
class ServiceFactory
{
    /**
     * Getter for a given version.
     *
     * @api
     * @param string $version
     * @todo return annotation
     * @todo throws annotation and functionality
     */
    public static function get(string $version)
    {
        if (is_numeric($version)) {
            $version = 'Version' . (int)$version;
        } else {
            $version = ucfirst($version);
        }
        $className = "\\Newland\\Toubiz\\Api\\Service\\{$version}\\VersionedService";
        return (new $className);
    }
}
