<?php
namespace Newland\Toubiz\Api\Service\Legacy;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\Toubiz\Api\Service\AbstractVersionedService;

/**
 * Service for legacy API version.
 *
 * Concrete implementation to communicate with
 * the first, "old" toubiz API version.
 */
class VersionedService extends AbstractVersionedService
{
    /**
     * @var string Base URI of API endpoint.
     */
    const BASE_URI = 'https://api.toubiz.de/json/';

    /**
     * Fetch active events.
     *
     * Passing 'all_in=1' yields all results instead of only the first 10.
     *
     * @override
     * @todo return annotation
     * @todo return type
     */
    public function fetchActiveEvents()
    {
        $response = $this->sendRequest('event/json_result.php', ['all_in' => 1]);
        if ($response) {
            return $response['result'];
        } else {
            return false;
        }
    }

    /**
     * Fetch details about the given event identifier.
     *
     * @override
     * @param string $identifier
     * @todo return annotation
     * @todo return type
     */
    public function fetchEventDetails(string $identifier)
    {
        $response = $this->sendRequest('event/json_detail.php', ['id' => $identifier]);
        if ($response) {
            return $response;
        } else {
            return false;
        }
    }

    /**
     * Send request to endpoint.
     *
     * This combines request parameters with required
     * authentication parameters and checks the response.
     *
     * @param string $path Relative path to self::BASE_URI to call
     * @param array $parameters Optional request parameters
     * @todo return annotation
     * @todo return type
     */
    protected function sendRequest(string $path, array $parameters = [])
    {
        $parameters = array_merge(
            $parameters,
            [
                'key' => $this->apiKey,
                'mandant' => $this->clientName
            ]
        );

        $response = $this->httpClient->request('GET', $path, ['query' => $parameters]);
        if ($response->getStatusCode() == 200) {
            $data = json_decode($response->getBody(), true);
            return $data;
        } else {
            return false;
        }
    }
}
