<?php
namespace Newland\Toubiz\Api\Repository;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\Toubiz\Api\ObjectAdapter\EventAdapterInterface;
use Newland\Toubiz\Api\ObjectAdapter\Legacy\EventAdapter;

/**
 * Event repository.
 *
 * Responsible for fetching events from the API.
 *
 * @todo strategy pattern for adapter invoking
 */
class EventRepository extends AbstractRepository
{
    /**
     * Get active events.
     *
     * Active events are events that are published
     * and have not already ended.
     *
     * @return array<EventAdapterInterface>
     */
    public function findAllActiveEvents()
    {
        $collection = [];
        $items = $this->service->fetchActiveEvents();
        if (!$items) {
            return;
        }

        foreach ($items as $item) {
            $collection[] = (new EventAdapter($item));
        }
        return $collection;
    }

    /**
     * Get data of a given event.
     *
     * Fetches data for a given event.
     *
     * @todo what happens on an invalid response?
     *
     * @param string $identifier Event identifier from the API.
     * @return EventAdapterInterface
     */
    public function findEvent(string $identifier)
    {
        $item = $this->service->fetchEventDetails($identifier);
        return (new EventAdapter($item));
    }
}
