<?php
namespace Newland\Toubiz\Api\ObjectAdapter\Legacy;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\Toubiz\Api\ObjectAdapter\AbstractObjectAdapter;

/**
 * Abstract legacy object adapter.
 *
 * Base adapter with shared functionality.
 */
abstract class AbstractLegacyObjectAdapter extends AbstractObjectAdapter
{
    /**
     * Finds the first matching key/value pair inside an array of arrays.
     *
     * @example
     *      $arr = [
     *          [
     *              "descriptionTypeID" => "",
     *              "descriptionTypeName" => "description"
     *              "description" => "..."
     *          ]
     *      ];
     *      $descriptionArray = $this->findInArray($arr, 'descriptionTypeName', 'description');
     *
     * @param array $array
     * @param mixed $searchKey
     * @param mixed $searchValue
     * @return array|null
     */
    protected function findInArray(array $array, $searchKey, $searchValue)
    {
        $result = array_filter(
            $array,
            function ($item) use ($searchKey, $searchValue) {
                return ((array)$item)[$searchKey] == $searchValue;
            }
        );

        if (count($result)) {
            return (array)array_shift($result);
        }
    }

    /**
     * Converts date and time strings into a DateTime object.
     *
     * @param string $date A date in YYYY-MM-DD format
     * @param string $time A time in hh:mm:ss format
     * @return \DateTime
     */
    protected function buildDateTimeFromStrings($date, $time = '')
    {
        $object = new \DateTime($date);
        if ($time) {
            list($hour, $minute, $_) = explode(':', $time);
            $object->setTime((int)$hour, (int)$minute);
        }
        return $object;
    }
}
