<?php
namespace Newland\PageFrameProvider\Routing;

use \Neos\Neos\Routing\FrontendNodeRoutePartHandler as OriginalFrontendNodeRoutePartHandler;
use Neos\Flow\Annotations as Flow;
use Newland\PageFrameProvider\Service\PageFrameContextService;

/**
 * Route part handler that will *always* match the root node of the current site no matter
 * which URL was given.
 *
 * If the given URL contains dimension information those will be respected and stripped from
 * the routePath.
 */
class FrontendNodeRoutePartHandler extends OriginalFrontendNodeRoutePartHandler
{

    /**
     * @var PageFrameContextService
     * @Flow\Inject()
     */
    protected $pageFrameContext;

    /**
     * @var RoutingHelper
     * @Flow\Inject()
     */
    protected $routingHelper;

    protected function findValueToMatch($routePath)
    {
        return $this->updateDimensionsInContext($routePath);
    }

    protected function removeMatchingPortionFromRequestPath(&$routePath, $valueToMatch)
    {
        $routePath = $this->routingHelper->prepareUrlForFurtherUseInRoutingPipeline($routePath);
    }

    protected function resolveValue($node)
    {
        $result = parent::resolveValue($node);
        if ($result && $this->value) {
            $this->updateDimensionsInContext($this->value);
        }
        return $result;
    }

    private function updateDimensionsInContext(string $routePath): string
    {
        $onlyDimensionValues = $this->routingHelper->extractDimensionValuesFromPath($routePath);
        $this->pageFrameContext->setDimensions(
            $this->parseDimensionsAndNodePathFromRequestPath($onlyDimensionValues)
        );
        return $onlyDimensionValues;
    }
}
