<?php declare(strict_types=1);


namespace Newland\PageFrameProvider\Tests\Utility;

use Neos\ContentRepository\Domain\Service\ContextFactoryInterface;
use Neos\Flow\Persistence\PersistenceManagerInterface;
use Neos\Neos\Domain\Service\SiteExportService;
use Neos\Neos\Domain\Service\SiteImportService;

trait ImportsSites
{
    public function importSite(): void
    {
        $this->contextFactory = $this->objectManager->get(ContextFactoryInterface::class);
        $contentContext = $this->contextFactory->create([ 'workspaceName' => 'live' ]);

        $this->siteImportService = $this->objectManager->get(SiteImportService::class);

        $this->siteExportService = $this->objectManager->get(SiteExportService::class);

        $this->importedSite = $this->siteImportService->importFromFile($this->fixtureFileName, $contentContext);

        $this->persistenceManager->persistAll();
    }
}
