<?php declare(strict_types=1);

namespace Newland\PageFrameProvider\NodeResolution;

use Neos\ContentRepository\Domain\Model\NodeInterface;

interface RootNodeResolver
{

    /**
     * Resolves the root node to link to for the given reference node.
     * The root node in this context is the node that is being used as a frame
     * around the main  content.
     *
     * @param NodeInterface $referenceNode
     * @return NodeInterface|null
     */
    public function resolveRootNode(?NodeInterface $referenceNode): ?NodeInterface;

    /**
     * Checks whether the given node path is allowed to be linked to.
     * The node path contains dimension values and workspace information
     * (e.g. `/sites/newland-toubizfrontend@live;language=en).
     *
     * In contrast to `resolveNode` this method is used when matching routes
     * to the correct node and should be implemented to prevent accidentally
     * matching an incorrect node (e.g. when the route definition is `{node}/foo/bar`
     * but a page with the path `foo/bar` exists that should not be linked to.
     *
     * @param string $path
     * @return bool
     */
    public function isNodePathAllowed(string $path): bool;

    public function setConfiguration(array $configuration): void;
}
