<?php declare(strict_types=1);

/*
 * Copyright (c) 2023, land in sicht AG
 *
 * www.land-in-sicht.de - All rights reserved.
 *
 * This is proprietary software. Unauthorized copying
 * of this file, via any medium, is strictly prohibited.
 */

namespace Newland\PageFrameProvider\Tests\Routing;

use Neos\ContentRepository\Domain\Service\ContextFactoryInterface;
use Neos\Flow\ObjectManagement\ObjectManager;
use Neos\Flow\Persistence\Doctrine\PersistenceManager;
use Neos\Flow\Security\Context;
use Neos\Flow\Tests\FunctionalTestCase;
use Neos\Neos\Domain\Service\ContentContextFactory;
use Neos\Neos\Domain\Service\ContentDimensionPresetSourceInterface;
use Neos\Neos\Domain\Service\SiteImportService;
use Newland\PageFrameProvider\NodeResolution\ConfigurationBasedNodeResolver;
use Newland\PageFrameProvider\Routing\FrontendNodeRoutePartHandler;
use Newland\PageFrameProvider\Service\PageFrameContextService;
use Newland\PageFrameProvider\Tests\Utility\ImportsSites;
use Psr\Log\LoggerInterface;
use Newland\PageFrameProvider\NodeResolution\SiteNodeResolver;

class FrontendNodeRoutePartHandlerTest extends FunctionalTestCase
{
    use ImportsSites;

    protected static $testablePersistenceEnabled = true;

    /**
     * @var string the Nodes fixture
     */
    protected $fixtureFileName = __DIR__ . '/Fixtures/Sites.xml';

    /**
     * @var SiteImportService
     */
    protected $siteImportService;

    /**
     * @var ContextFactoryInterface
     */
    protected $contextFactory;

    /**
     * @var FrontendNodeRoutePartHandler
     */
    protected $subject;

    /**
     * @var PersistenceManager
     */
    protected $persistenceManager;

    public function setUp(): void
    {
        parent::setUp();

        $this->subject = $this->objectManager->get(FrontendNodeRoutePartHandler::class);
        $nodeResolver = $this->objectManager->get(ConfigurationBasedNodeResolver::class);

        $this->inject($nodeResolver, 'resolutionConfiguration', [ 'class' => SiteNodeResolver::class ]);
        $this->inject($nodeResolver, 'objectManager', $this->objectManager->get(ObjectManager::class));
        $this->inject($this->subject, 'contextFactory', $this->objectManager->get(ContentContextFactory::class));
        $this->inject($this->subject, 'pageFrameContext', $this->objectManager->get(PageFrameContextService::class));
        $this->inject($this->subject, 'nodeResolver', $nodeResolver);
        $this->inject($this->subject, 'securityContext', $this->objectManager->get(Context::class));
        $this->inject(
            $this->subject,
            'contentDimensionPresetSource',
            $this->objectManager->get(ContentDimensionPresetSourceInterface::class)
        );
        $this->inject($this->subject, 'systemLogger', $this->objectManager->get(LoggerInterface::class));

        $this->importSite();
    }

    public function tearDown(): void
    {
        parent::tearDown();

        $this->inject($this->contextFactory, 'contextInstances', []);
    }

    /**
     * @dataProvider provideRoutePaths
     * @param bool $expectMatch
     * @param string $name
     * @param string $path
     */
    public function testRouteHandling(bool $expectMatch, string $name, string $path): void
    {
        $this->markTestSkipped('Needs investigating.');

        $this->subject->setName($name);
        $this->assertEquals(
            $expectMatch,
            $this->subject->match($path)
        );
    }

    public function provideRoutePaths(): array
    {
        return [
            [ true, 'Acme.Demo:Page', 'example' ],
            [ true, 'Acme.Demo:Page', 'ttt' ],
            [ true, '--plugin.article', 'foo/article-12345' ],
            [ true, '--plugin.article', '//article-12345' ],
        ];
    }
}
