<?php declare(strict_types=1);

/*
 * Copyright (c) 2023, land in sicht AG
 *
 * www.land-in-sicht.de - All rights reserved.
 *
 * This is proprietary software. Unauthorized copying
 * of this file, via any medium, is strictly prohibited.
 */

namespace Newland\PageFrameProvider\Tests\NodeResolution;

use Newland\PageFrameProvider\NodeResolution\SiteNodeResolver;
use PHPUnit\Framework\TestCase;

class SiteNodeResolverTest extends TestCase
{
    /**
     * @dataProvider provideNodePaths
     * @param bool $expectMatch
     * @param string $path
     */
    public function testCheckOnlyPermitsSiteNodePaths(bool $expectMatch, string $path): void
    {
        $this->assertEquals(
            $expectMatch,
            (new SiteNodeResolver())->isNodePathAllowed($path)
        );
    }

    public function provideNodePaths(): array
    {
        return [
            [ true, '/sites/newland-foobar@live;language=en' ],
            [ true, '/sites/newland-foobar@preview' ],
            [ true, '/sites/newland-foobar' ],
            [ true, '/sites/newland-foobar;language-en' ],
            [ false, '/sites/newland-foobar/node-abcdef@live;language=de' ],
            [ false, '/some/other/path' ],
            [ false, 'some/other/path' ],
        ];
    }
}
