<?php

namespace Newland\PageFrameProvider\Routing;

use Neos\Flow\Mvc\Routing\AbstractRoutePart;
use Neos\Flow\Mvc\Routing\Dto\MatchResult;
use Neos\Flow\Mvc\Routing\Dto\ResolveResult;
use Neos\Flow\Mvc\Routing\DynamicRoutePartInterface;
use Neos\Flow\ObjectManagement\ObjectManager;

/**
 * Wraps a route handler in order to extend it cleanly.
 */
abstract class CompositeRouteHandler extends AbstractRoutePart implements DynamicRoutePartInterface
{

    /**
     * @var DynamicRoutePartInterface
     */
    protected $compositeRouteHandler;
    abstract public function injectCompositeRouteHandler(ObjectManager $objectManager): void;

    public function matchCompositeRouteHandler(&$routePath)
    {
        $result = $this->compositeRouteHandler->match($routePath);
        if ($result === true) {
            $result = new MatchResult($this->compositeRouteHandler->getValue());
        }
        return $result;
    }

    /** @return false|ResolveResult */
    public function resolveCompositeRouteHandler(array &$routeValues)
    {
        $result = $this->compositeRouteHandler->resolve($routeValues);
        if ($result === true) {
            $result = new ResolveResult($this->compositeRouteHandler->getValue());
        }
        return $result;
    }

    public function setSplitString($splitString)
    {
        $this->compositeRouteHandler->setSplitString($splitString);
    }

    public function setName($name)
    {
        parent::setName($name);
        $this->compositeRouteHandler->setName($name);
    }

    public function setLowerCase($lowerCase)
    {
        parent::setLowerCase($lowerCase);
        $this->compositeRouteHandler->setLowerCase($lowerCase);
    }

    public function setOptional($optional)
    {
        parent::setOptional($optional);
        $this->compositeRouteHandler->setOptional($optional);
    }
}
