<?php
namespace Newland\PageFrameProvider\Routing;

use \Neos\Neos\Routing\FrontendNodeRoutePartHandler as OriginalFrontendNodeRoutePartHandler;

/**
 * Same as the Neos default FrontendNodeRoutePartHandler which resolves nodes in URLs,
 * but with preset configuration instead of relying on global site configuration:
 *
 * - Only matches site nodes
 * - Adds dimension segments (e.g. languages) to the URL even if it is the default value for
 *   the dimension - therefor enforcing a language segment in the URL.
 */
class FrontendNodeRoutePartHandler extends OriginalFrontendNodeRoutePartHandler
{
    protected $supportEmptySegmentForDimensions = false;

    protected function onlyMatchSiteNodes(): bool
    {
        return true;
    }
}
