<?php
namespace Newland\PageFrameProvider\Controller;

use Neos\ContentRepository\Domain\Model\Node;
use Neos\Flow\Mvc\Controller\ActionController;
use Neos\Neos\View\FusionView;
use Newland\PageFrameProvider\Domain\Repository\NodeRepository;
use Newland\PageFrameProvider\Service\PageFrameLinkingService;

/**
 * Renders the page frame with a custom plugin as content.
 * @see PageFrameLinkingService
 */
class PageFrameController extends ActionController
{
    /** @var string */
    protected $defaultViewObjectName = FusionView::class;

    /** @var FusionView */
    protected $view;

    public function showAction(Node $node = null, string $pageFrame = 'default')
    {
        $this->view->setFusionPath('pageFrame/' . $pageFrame);
        $this->view->assignMultiple([ 'value' => $node ]);
    }
}
