<?php declare(strict_types=1);

namespace Newland\PageFrameProvider\Breadcrumb;

use Newland\NeosMetaTags\Service\MetaDataService;
use Neos\Flow\Annotations as Flow;

class MenuItemsImplementation extends \Neos\Neos\Fusion\MenuItemsImplementation
{
    /**
     * @var MetaDataService
     * @Flow\Inject()
     */
    protected $metaDataService;

    protected function buildItems()
    {
        $label = $this->label();
        $append = [];
        if ($label) {
            $append[] = [ 'state' => static::STATE_CURRENT, 'label' => $label ];
        }
        return array_merge($append, parent::buildItems());
    }

    private function label(): ?string
    {
        $label = $this->metaDataService->getTitle(
            $this->fusionValue('node'),
            $this->fusionValue('request')
        );

        return $label ?: null;
    }
}
