<?php declare(strict_types=1);

namespace Newland\PageFrameProvider\Eel\Helper;

use Neos\Eel\ProtectedContextAwareInterface;

class ContextHelper implements ProtectedContextAwareInterface
{
    public function url(): string
    {
        $protocol = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http';
        return sprintf('%s://%s%s', $protocol, $_SERVER['HTTP_HOST'], $_SERVER['REQUEST_URI']);
    }

    public function allowsCallOfMethod($methodName)
    {
        return $methodName === 'url';
    }
}
