<?php declare(strict_types=1);

/*
 * Copyright (c) 2023, land in sicht AG
 *
 * www.land-in-sicht.de - All rights reserved.
 *
 * This is proprietary software. Unauthorized copying
 * of this file, via any medium, is strictly prohibited.
 */

namespace Newland\PageFrameProvider\Tests\NodeResolution\Mock;

use Newland\PageFrameProvider\NodeResolution\RootNodeResolver;
use Neos\ContentRepository\Domain\Model\NodeInterface;

class ResolverImplementingInterface implements RootNodeResolver
{
    public static $calls = 0;

    public static $lastSetConfiguration;

    public static $isNodePathAllowed = true;

    public function resolveRootNode(?NodeInterface $referenceNode): ?NodeInterface
    {
        static::$calls++;
        return null;
    }

    public function setConfiguration(array $configuration): void
    {
        static::$lastSetConfiguration = $configuration;
    }

    public function isNodePathAllowed(?string $path): bool
    {
        return static::$isNodePathAllowed;
    }
}
