<?php
namespace Newland\PageFrameProvider\Service;

use Neos\ContentRepository\Domain\Model\Node;
use Neos\Flow\Annotations as Flow;

/**
 * @Flow\Scope("singleton")
 */
class PageFrameContextService
{

    /** @var array */
    protected $pluginArguments;

    /** @var Node */
    protected $node;

    /** @var array */
    protected $breadcrumbConfig;

    /** @var array */
    protected $alternativeDimensionsConfig;

    /** @var array */
    protected $dimensions;

    public function getPluginArguments(): array
    {
        return $this->pluginArguments;
    }

    public function setPluginArguments(array $pluginArguments)
    {
        $this->pluginArguments = $pluginArguments;
    }

    public function getBreadcrumbConfig(): ?array
    {
        return $this->breadcrumbConfig;
    }

    public function setBreadcrumbConfig(array $breadcrumbConfig)
    {
        $this->breadcrumbConfig = $breadcrumbConfig;
    }

    public function getAlternativeDimensionsConfig(): ?array
    {
        return $this->alternativeDimensionsConfig;
    }

    public function setAlternativeDimensionsConfig(array $alternativeDimensionsConfig): void
    {
        $this->alternativeDimensionsConfig = $alternativeDimensionsConfig;
    }

    public function getDimensions(): array
    {
        return $this->dimensions ?? [];
    }

    public function setDimensions(array $dimensions)
    {
        $this->dimensions = $dimensions;
    }

    public function getNode(): Node
    {
        return $this->node;
    }

    public function setNode(Node $node): void
    {
        $this->node = $node;
    }
}
