<?php declare(strict_types=1);

/*
 * Copyright (c) 2023, land in sicht AG
 *
 * www.land-in-sicht.de - All rights reserved.
 *
 * This is proprietary software. Unauthorized copying
 * of this file, via any medium, is strictly prohibited.
 */

namespace Newland\PageFrameProvider\Service;

use Neos\ContentRepository\Domain\Model\Node;
use Neos\Flow\Mvc\RequestInterface;

class MetaDataService implements MetaDataServiceInterface
{
    public function getTitle(Node $node, RequestInterface $request, bool $appendWebsite = false): ?string
    {
        if ($node->hasProperty('title') === false) {
            return null;
        }

        return $node->getProperty('title') ?: null;
    }
}
