<?php declare(strict_types=1);

namespace Newland\PageFrameProvider\Breadcrumb;

use Neos\Flow\ObjectManagement\ObjectManager;
use Neos\Flow\Annotations as Flow;
use Newland\PageFrameProvider\Service\MetaDataServiceInterface;

class MenuItemsImplementation extends \Neos\Neos\Fusion\MenuItemsImplementation
{
    /**
     * @var ObjectManager
     * @Flow\Inject()
     */
    protected $objectManager;
    /**
     * @var array
     * @Flow\InjectConfiguration()
     */
    protected $configuration;

    protected function buildItems()
    {
        $label = $this->label();
        $append = [];
        if ($label) {
            $append[] = [ 'state' => static::STATE_CURRENT, 'label' => $label ];
        }
        return array_merge($append, parent::buildItems());
    }

    private function label(): ?string
    {
        $metaDataService = $this->objectManager->get($this->configuration['metaDataService']);

        if (method_exists($metaDataService, 'getTitle') === false) {
            return null;
        }

        $label = $metaDataService->getTitle(
            $this->fusionValue('node'),
            $this->fusionValue('request')
        );

        return $label ?: null;
    }
}
