<?php declare(strict_types=1);

namespace Newland\PageFrameProvider\NodeResolution;

use Neos\ContentRepository\Domain\Model\NodeInterface;
use Neos\Neos\Domain\Service\ContentContext;
use function Safe\preg_match;
use function Safe\preg_split;

/**
 * Resolves the root node to the site node of the given reference node.
 */
class SiteNodeResolver implements RootNodeResolver
{

    public function setConfiguration(array $configuration): void
    {
        // This resolver has no need for configuration.
    }

    /**
     * @param NodeInterface|null $referenceNode
     * @return NodeInterface|null
     */
    public function resolveRootNode(?NodeInterface $referenceNode = null): ?NodeInterface
    {
        if (!$referenceNode) {
            return null;
        }

        $context = $referenceNode->getContext();
        if (!($context instanceof ContentContext)) {
            return null;
        }

        return $context->getCurrentSiteNode();
    }

    public function isNodePathAllowed(string $path): bool
    {
        list($path) = preg_split('/[@;]/', $path);
        return (bool) preg_match('/^\/sites\/[\w-]+$/', $path);
    }
}
