<?php declare(strict_types=1);


namespace Newland\PageFrameProvider;

use Neos\Flow\Annotations as Flow;
use Neos\Flow\Aop\JoinPointInterface;
use Newland\PageFrameProvider\Service\PageFrameContextService;

/**
 * @Flow\Aspect()
 */
class DimensionExtractionAspect
{

    /**
     * @var PageFrameContextService
     * @Flow\Inject()
     */
    protected $pageFrameContext;

    /**
     * phpcs:disable Generic.Files.LineLength.TooLong
     * @Flow\After("method(Neos\Neos\Routing\FrontendNodeRoutePartHandler->parseDimensionsAndNodePathFromRequestPath())")
     * phpcs:enable
     */
    public function parseDimensionsAndNodePathFromRequestPath(JoinPointInterface $joinPoint): void
    {
        $dimensions = $joinPoint->getResult();
        if ($dimensions && empty($this->pageFrameContext->getDimensions())) {
            $this->pageFrameContext->setDimensions($dimensions);
        }
    }
}
