<?php declare(strict_types=1);

namespace Newland\PageFrameProvider\Breadcrumb;

use Newland\NeosCommon\Eel\Helper\PageTitleHelper;
use Neos\Flow\Annotations as Flow;

class MenuItemsImplementation extends \Neos\Neos\Fusion\MenuItemsImplementation
{

    /**
     * @var PageTitleHelper
     * @Flow\Inject()
     */
    protected $pageTitleHelper;

    protected function buildItems()
    {
        $label = $this->label();
        $append = [];
        if ($label) {
            $append[] = [ 'state' => static::STATE_CURRENT, 'label' => $label ];
        }
        return array_merge($append, parent::buildItems());
    }

    private function label(): ?string
    {
        $label = $this->pageTitleHelper->getTitle(
            $this->fusionValue('node'),
            $this->fusionValue('request'),
            null,
            false
        );

        return $label ?: null;
    }
}
