<?php
namespace Newland\PageFrameProvider\Routing;

use Neos\ContentRepository\Domain\Model\NodeInterface;
use \Neos\Neos\Routing\FrontendNodeRoutePartHandler as OriginalFrontendNodeRoutePartHandler;
use Neos\Flow\Annotations as Flow;
use Newland\PageFrameProvider\Service\PageFrameContextService;

/**
 * Route part handler that will *always* match the root node of the current site no matter
 * which URL was given.
 *
 * If the given URL contains dimension information those will be respected and stripped from
 * the routePath.
 */
class FrontendNodeRoutePartHandler extends OriginalFrontendNodeRoutePartHandler
{

    /**
     * @var PageFrameContextService
     * @Flow\Inject()
     */
    protected $pageFrameContext;

    /**
     * @var RoutingHelper
     * @Flow\Inject()
     */
    protected $routingHelper;

    protected function matchValue($requestPath)
    {
        return parent::matchValue($this->routingHelper->extractDimensionValuesFromPath($requestPath));
    }

    protected function removeMatchingPortionFromRequestPath(&$routePath, $valueToMatch)
    {
        $routePath = $this->routingHelper->prepareUrlForFurtherUseInRoutingPipeline($routePath);
    }

    /**
     * @param NodeInterface|string $node
     * @return bool
     */
    protected function resolveValue($node)
    {
        $result = parent::resolveValue($node);
        if ($result && !\is_string($node)) {
            $this->pageFrameContext->setDimensions(
                $node->getContext()->getTargetDimensionValues()
            );
        }
        return $result;
    }

    protected function findValueToMatch($requestPath)
    {
        $this->updateDimensionsInContext($requestPath);
        return parent::findValueToMatch($requestPath);
    }

    private function updateDimensionsInContext(string $routePath): void
    {
        $onlyDimensionValues = $this->routingHelper->extractDimensionValuesFromPath($routePath);
        if (!$onlyDimensionValues) {
            return;
        }

        $dimensions = $this->parseDimensionsAndNodePathFromRequestPath($onlyDimensionValues);
        if (!$dimensions) {
            return;
        }

        $this->pageFrameContext->setDimensions($dimensions);
    }
}
