# Page Frame Provider

## Declaring Routes
Plugins can be registered as static routes in `Routes.yaml`. However, when registered
in this way they are not visually embedded into the site - but rather  have their completely
own rendering. The `PageFrameController` is a small helper to render a  page frame as defined
in the site package but with a statically registered Plugin as content.

This way a Detail page for example can be registered side-wide and must not be on any
particular page. In order for this to work correctly the route must be registered in
the following way:

```yaml
#
# Example route configuration for a page frame plugin.
# A page frame plugin is registered as a static route
# (is independent of a specific node) but still renders the
# frame defined by the page template around it.
#
-
  name: 'My.Vendor:MyDetailView'
  uriPattern: '<PageFrame>/my-path/{--plugin.myControllerArgument}'
  defaults:
    '--plugin':
      '@package': 'my.vendor'
      '@controller': 'mycontroller'
      '@action': 'myaction'
      '_articleType': 2  # read more about this below
  subRoutes:
    PageFrame:
      package: 'Newland.PageFrameProvider'
  routeParts:
    '--plugin.myControllerArgument':
      objectType: 'My\Vendor\Domain\Model\MyModel'
      uriPattern: '{name}'
```

## Link Generation
`PageFrameLinkingService` can be used to generate links to page frame plugins.

NOTE: Arguments starting with an underscore (such as `_articleType` in the example above)
will be ignored when building URLs and can be used to identify the route if multiple similar
routes exist.


## Breadcrumbs
If you want to have breadcrumbs you will need to implement a provider implementing the
`BreadcrumbProvider` interface. You can then specify it for your pageFrame object.
If you specified `pageFrame: 'myCustomFrame'` in your route then the following configuration
will add breadcrumbs:

```yaml
Newland:
  PageFrameProvider:
    breadcrumb:
      myCustomFrame:
        provider: 'My\Vendor\PageFrame\MyFancyBreadcrumbProvider'
        randomConfigOptionForProvider: 'foo'
        anotherOption: 'bar'
```

## Using a different base view
By default `PageFrameProvider` uses the fusion object `Neos.NodeTypes:Page` in order to render
the frame around the plugin. If you want to use a different fusion object
(e.g. if you use `Neos.NodeTypes:Page` only for the home page and a different object for subpages
without a big header) then you can do so using the `type` property:

```neosfusion
# For all PageFrames
prototype(Newland.PageFrameProvider:PageFrame).type = 'My.Site:CustomSubPage'

# For specific views only
pageFrame.default.type = 'My.Site:CustomSubPage'
pageFrame.poiDetail.type = 'My.Site:AnotherCustomSubPage'
```

If you need to pass parameters down into the view to enable or disable some features then
this can be done by editing the inner prototype:

```neosfusion
# For all PageFrames
prototype(Newland.PageFrameProvider:PageFrame) {
    prototype(Neos.NodeTypes:Page) {
        body {
            hasHero = false
            showIntro = false
        }
    }
}

# For specific views only
pageFrame.poiDetail {
    prototype(Neos.NodeTypes:Page) {
        body {
            hasHero = false
            showIntro = false
        }
    }
}
```

## Template conditions
Every template view is injected with a `isPageFrame` variable which is set to `true` if the
template is rendered in a PageFrame. This allows for conditions such as the following:

```html
<f:if condition="{node.path} == '/sites/newland-tuntheme' && !{isPageFrame}">
    <!-- Render special thing on home page but not in page frame -->
</f:if>
```