<?php
namespace Newland\PageFrameProvider\Definition;

class RouteDefinition
{
    const FALLBACK_SEGMENT = '_fallback';

    /** @var string[][] */
    private $uriSegments;

    /** @var string[] */
    private $breadcrumb;

    /**
     * @param string|array $config
     */
    public function __construct($config)
    {
        if (\is_string($config)) {
            $config = [ 'uriSegment' => [ static::FALLBACK_SEGMENT => $config ] ];
        }

        if (\is_string($config['uriSegment'])) {
            $config['uriSegment'] = [ static::FALLBACK_SEGMENT => $config['uriSegment'] ];
        }

        $this->breadcrumb = $config['breadcrumb'] ?? [];
        $this->uriSegments = array_map(
            function (string $uri) {
                return trim($uri, '/');
            },
            $config['uriSegment'] ?? []
        );
    }

    public function getUriSegment(string $language = null)
    {
        return $this->uriSegments[$language]
            ?? $this->uriSegments[static::FALLBACK_SEGMENT]
            ?? null;
    }

    public function getUriSegments(): array
    {
        return $this->uriSegments;
    }

    public function getBreadcrumb(): array
    {
        return $this->breadcrumb;
    }
}
