<?php declare(strict_types=1);

namespace Newland\PageFrameProvider\Tests\Utility;

use Newland\PageFrameProvider\Utility\ArrayUtility;
use PHPUnit\Framework\TestCase;

class ArrayUtilityTest extends TestCase
{

    /**
     * @dataProvider associativeArrayItemsDataProvider
     * @param array $input
     * @param array $expected
     */
    public function testStripsOutAssociativeArrayItems(array $input, array $expected): void
    {
        $this->assertEquals($expected, ArrayUtility::removeAssociativeArrayItems($input));
    }

    public function associativeArrayItemsDataProvider(): array
    {
        return [
            [
                [ 'foo', 'bar', 'baz' ],
                [ 'foo', 'bar', 'baz' ]
            ],
            [
                [ 'foo', 'bar' => 'baz' ],
                [ 'foo' ]
            ],
            [
                [ '1' => 'foo', 0 => 'test', 'bar' => 'baz' ],
                [ 'test', 'foo' ]
            ],
        ];
    }

}