# Changelog
All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [2.0.10] - 2019-11-20
### Added
- The `PageFrameLinkingService` can now generate absolute URIs if you want to.

## [2.0.9] - 2019-10-02
### Fixed
- Issue where the routes was getting a double slash appended.

## [2.0.8] - 2019-09-17
### Changed
- Get page titles through `neos-meta-tags`

## [2.0.7] - 2019-08-21
### Fixed
- Fixed sites without explicit domain mapping not resolving URLs correctly
- Fixed breadcrumbs in page frames being cached incorrectly leading to the first generated breadcrumb being
  displayed on all page frames.
- Fixed websites with default language in path but without RoutingBehaviourHooks not resolving URLs correctly.

## [2.0.6] - 2019-08-15
### Added
- Breadcrumbs can now be configured on a per-site basis using the node name to
  identify the site. This capability is now provided with PageFrameProvider but must
  be explicitly enabled in packages using it.
- The configuration path `Newland.PageFrameProvider.nodeResolution` can now be used to influence
  the resolution of nodes used for page frame links.

## [2.0.4] - 2019-06-28
### Fixed
- Fixed an issue where dimensions are not correctly detected if not used in combination
  with `newland/neos-routing-behaviour-hooks`.

## [2.0.3] - 2019-06-07
### Fixed
- Fixed page frame provider pages not resolving dimensions correctly if no language segment in URI
  and default language is not DE.
- Fixed PageFrameProvider being incompatible with hostname based
  dimension resolution from `Newland.NeosRoutingBehaviourHooks`

## [2.0.2] - 2019-05-07
### Fixed
- BreadcrumbMenu is now compatible with Neos 4.3
- Fixed issues with upcoming `Newland.RoutingBehaviourHooks` package

### Breaking Changes
- `BreadcrumbProvider` interface has been moved to `Newland\PageFrameProvider\Breadcrumb\`.
  The interface was only moved, the definition remains the same.

## [2.0.1] - 2019-04-03
### Fixed
- Fixed breaking URLs without language segments.

## [2.0.0] - 2019-04-02
### Added
- PageFrameProvider routes can now declare `BreadcrumbProviders` for custom breadcrumbs.
- New base fusion object can now be specified using `pageFrame.default.type = 'Your.Site:CustomSubPage'`
  without having to override the whole fusion object.
- Every template rendered in a PageFrame now can access a `isPageFrame` variable for building conditions.
- `PageFrameContextService` can now be injected in order to access details about the current page frame route. This can be useful if code external to this package needs to access the current node or dimension values.
- `RouteConfigurationHelper` can be used for implementing custom route parts based on page frames using a clearly defined configuration format. This helper resolves paths & dimensions.

### Breaking Changes
- `Newland.PageFrameProvider:PageFrame` is now not a page object itself but a renderer that renders
  a page object. This means that customizations to page frames now have to be done to 
  `prototype(Newland.PageFrameProvider:PageFrame).prototype(Neos.NodeTypes:Page)` instead of
  `prototype(Newland.PageFrameProvider:PageFrame)`.

```neosfusion
# A custom wrap
pageFrame.poiDetail = Newland.PageFrameProvider:PageFrame {
    body.content.main.@process.wrapWithContainer = ${'<div class="o-container mt-8">' + value + '</div>'}
}

# Must be applied to the sub-prototype
pageFrame.poiDetail = Newland.PageFrameProvider:PageFrame {
    prototype(Neos.NodeTypes:Page) {
        body.content.main.@process.wrapWithContainer = ${'<div class="o-container mt-8">' + value + '</div>'}
    }
}
```
