<?php
namespace Newland\PageFrameProvider\Fusion;

use Neos\ContentRepository\Domain\Model\NodeInterface;
use Neos\Eel\FlowQuery\FlowQuery;

interface BreadcrumbProvider
{

    /**
     * Must return an array of nodes that should be in the breadcrumb before
     * the current page. The first node in the array corresponds to the first
     * array in the breadcrumb (closest to the siteNode).
     *
     * @param NodeInterface $siteNode
     * @param array $configuration
     * @return NodeInterface[]
     */
    public function selectBreadCrumbs(NodeInterface $siteNode, array $configuration): array;
}
