<?php
namespace Newland\PageFrameProvider\Fusion;

use Neos\ContentRepository\Domain\Model\NodeInterface;
use Neos\Flow\Configuration\Exception\InvalidConfigurationException;
use Neos\Flow\ObjectManagement\Exception\InvalidObjectException;
use Neos\Flow\ObjectManagement\ObjectManager;
use Neos\Neos\Domain\Service\ContentContext;
use Neos\Neos\Fusion\MenuImplementation;
use Neos\Flow\Annotations as Flow;
use Newland\PageFrameProvider\Service\PageFrameContextService;

/**
 * Breadcrumb implementation that overrides the default breadcrumb handling with one that
 * allows developer provided providers.
 */
class BreadcrumbImplementation extends MenuImplementation
{
    /**
     * @var PageFrameContextService
     * @Flow\Inject()
     */
    protected $pageFrameContext;

    /**
     * @var ObjectManager
     * @Flow\Inject
     */
    protected $objectManager;

    public function getItemCollection()
    {
        $siteNode = $this->siteNode();
        if (!$siteNode) {
            return [];
        }

        return array_reverse(
            $this->provider()->selectBreadCrumbs($siteNode, $this->config())
        );
    }

    private function config(): array
    {
        return $this->pageFrameContext->getBreadcrumbConfig() ?: [];
    }

    private function provider(): BreadcrumbProvider
    {
        $config = $this->config();

        $className = NullProvider::class;
        if (array_key_exists('provider', $config)) {
            $className = $config['provider'];
        }

        if (!class_exists($className)) {
            throw new InvalidConfigurationException('No breadcrumb provider ' . $className . ' exists');
        }

        $instance = $this->objectManager->get($className);
        if (!($instance instanceof BreadcrumbProvider)) {
            throw new InvalidObjectException(
                'Breadcrumb providers must implement ' . BreadcrumbProvider::class
                . ' but ' . get_class($instance) . ' does not.'
            );
        }

        return $instance;
    }

    /**
     * @return NodeInterface|null
     */
    private function siteNode()
    {
        $context = $this->currentNode->getContext();
        if (!($context instanceof ContentContext)) {
            return null;
        }
        return $context->getCurrentSiteNode();
    }
}
