# Page Frame Provider

Plugins can be registered as static routes in `Routes.yaml`. However, when registered
in this way they are not visually embedded into the site - but rather  have their completely
own rendering. The `PageFrameController` is a small helper to render a  page frame as defined
in the site package but with a statically registered Plugin as content.

This way a Detail page for example can be registered side-wide and must not be on any
particular page. In order for this to work correctly the route must be registered in
the following way:

```yaml
#
# Example route configuration for a page frame plugin.
# A page frame plugin is registered as a static route
# (is independent of a specific node) but still renders the
# frame defined by the page template around it.
#
-
  name: 'My.Vendor:MyDetailView'
  uriPattern: '<PageFrame>/my-path/{--plugin.myControllerArgument}'
  defaults:
    '--plugin':
      '@package': 'my.vendor'
      '@controller': 'mycontroller'
      '@action': 'myaction'
      '_articleType': 2  # read more about this below
  subRoutes:
    PageFrame:
      package: 'Newland.PageFrameProvider'
  routeParts:
    '--plugin.myControllerArgument':
      objectType: 'My\Vendor\Domain\Model\MyModel'
      uriPattern: '{name}'
```

By default the page defined in the Fusion path `prototype(Neos.NodeTypes:Page)`
is being rendered. If you want to render a different node type as your frame
you can define a new page frame type under `pageFrame.myCustomPageFrame` similar
to the one in `pageFrame.default` a pass the name of that pageFrame into
`PageFrameController` as an argument (in the `defaults` section of the route declaration).

`PageFrameLinkingService` can be used to generate links to page frame plugins.

NOTE: Arguments starting with an underscore (such as `_articleType` in the example above)
will be ignored when building URLs and can be used to identify the route if multiple similar
routes exist.
