<?php

namespace Newland\NeosViewHelpers\ViewHelpers\Collection;

/*
 * This file is part of the "neos-viewhelpers" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Doctrine\ORM\PersistentCollection;
use Neos\FluidAdaptor\Core\ViewHelper\AbstractViewHelper;

/**
 * Slice view helper.
 *
 * Extracts a slice of a collection.
 */
class SliceViewHelper extends AbstractViewHelper
{
    public function initializeArguments(): void
    {
        $this->registerArgument('collection', 'mixed', '', true);
        $this->registerArgument('offset', 'int', '', true);
        $this->registerArgument('length', 'int', '');
    }

    public function render(): array
    {
        $collection = $this->arguments['collection'];

        if ($collection instanceof PersistentCollection) {
            $collection = $collection->getValues();
        }

        if (!is_array($collection)) {
            return [];
        }

        return array_slice($collection, $this->arguments['offset'], $this->arguments['length']);
    }
}
