<?php

namespace Newland\NeosViewHelpers\ViewHelpers\Collection;

/*
 * This file is part of the "neos-viewhelpers" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\FluidAdaptor\Core\ViewHelper\AbstractViewHelper;

/**
 * collection.generate view helper.
 *
 * Takes an argument `items` (integer) and returns an array.
 *
 * @example
 * Render certain markup 5 times.
 * `
 *  <f:for each="{vh:collection.generate(items: 5)}" as="index">
 *      ((MARKUP))
 *  </f:for>
 * `
 */
class GenerateViewHelper extends AbstractViewHelper
{
    public function initializeArguments(): void
    {
        $this->registerArgument('items', 'array', 'The number of items in the created array.', false, 1);
    }

    public function render(): array
    {
        return range(0, $this->arguments['items'] - 1);
    }
}
