<?php
namespace Newland\NeosViewHelpers\ViewHelpers\Type;

/*
 * This file is part of the "neos-viewhelpers" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\FluidAdaptor\Core\ViewHelper\AbstractViewHelper;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;

/**
 * Is object view helper.
 *
 * Checks if a given value is of type object.
 *
 * WARNING:
 * Some values can be of type object even though you might expect them to be something else.
 * Be aware of that when using this viewhelper.
 *
 * @example
 * <f:if condition="{formValue -> vh:type.isObject()}">
 *      <f:then>
 *          {formValue.someChildValue}
 *      </f:then>
 *      <f:else>
 *          {formValue}
 *      </f:else>
 * </f:if>
 */
class IsObjectViewHelper extends AbstractViewHelper
{
    public function initializeArguments(): void
    {
        $this->registerArgument('value', 'mixed', 'The value to check', false, null);
    }

    public static function renderStatic(
        array $arguments,
        \Closure $renderChildrenClosure,
        RenderingContextInterface $renderingContext
    ): bool {
        return is_object($arguments['value'] ?? $renderChildrenClosure());
    }
}
