<?php
namespace Newland\NeosViewHelpers\ViewHelpers\String;

/*
 * This file is part of the "neos-viewhelpers" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\FluidAdaptor\Core\ViewHelper\AbstractViewHelper;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;

/**
 * Simple ViewHelper that checks whether or not a string is empty ignoring common 'empty but not empty'
 * cases such as a HTML-encoded `&nbsp;`.
 *
 * @example
 * <!-- myVar being '', '    ' or '&nbsp;' -->
 * <f:if condition="{myVar -> vh:string.notEmpty()}">
 *      <f:else><!-- FALSE --></f:else>
 * </f:if>
 *
 * @example
 * <!-- myVar being 'foobar' -->
 * <f:if condition="{myVar -> vh:string.notEmpty()}">
 *      <!-- TRUE -->
 * </f:if>
 */
class NotEmptyViewHelper extends AbstractViewHelper
{

    public function initializeArguments(): void
    {
        $this->registerArgument('string', 'string', null, false, null);
        $this->registerArgument('ignoreEmptyTags', 'boolean', null, false, false);
    }

    public static function renderStatic(
        array $arguments,
        \Closure $renderChildrenClosure,
        RenderingContextInterface $renderingContext
    ): bool {
        $string = $arguments['string'] ?? $renderChildrenClosure();

        $string = html_entity_decode($string);
        $string = trim($string, "\xC2\xA0\n\t ");

        if ($arguments['ignoreEmptyTags']) {
            $string = strip_tags($string);
        }

        return !empty($string);
    }
}
