<?php
namespace Newland\NeosViewHelpers\ViewHelpers\Pagination;

/*
 * This file is part of the "neos-viewhelpers" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\FluidAdaptor\Core\ViewHelper\AbstractViewHelper;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;

/**
 * Pagination items view helper.
 *
 * Returns an array of items as base for a pagination.
 *
 * The param $pagination expects the following keys:
 *   - page: the current page
 *   - count:
 *     - items: total count of items
 *     - pages: total count of pages
 *
 */
class ItemsViewHelper extends AbstractViewHelper
{
    /**
     * Calculation base for moving.
     *
     * @var int
     */
    const PAGE_WINDOW = 4;

    public function initializeArguments()
    {
        $this->registerArgument('pagination', 'array', null, true);
    }

    public static function renderStatic(
        array $arguments,
        \Closure $renderChildrenClosure,
        RenderingContextInterface $renderingContext
    ): array {
        $pagination = $arguments['pagination'];
        $items = [];

        // No logic is required if the total amount of pages is smaller than MAX_PAGES to display.
        if ($pagination['count']['pages'] <= (self::PAGE_WINDOW * 2 + 1)) {
            static::injectRange($items, 1, $pagination['count']['pages']);
            return $items;
        }

        if ($pagination['page'] > self::PAGE_WINDOW + 1) {
            $rangeStart = $pagination['page'] - self::PAGE_WINDOW;
        } else {
            $rangeStart = 1;
        }

        $rangeEnd = $rangeStart + (2 * self::PAGE_WINDOW);
        if ($rangeEnd > $pagination['count']['pages']) {
            $diff = $rangeEnd - $pagination['count']['pages'];
            $rangeStart -= $diff;
            $rangeEnd = $pagination['count']['pages'];
        }

        static::injectRange($items, (int) $rangeStart, (int) $rangeEnd);
        return $items;
    }


    /**
     * Injects an integer range into the given array.
     *
     * @param array $array
     * @param int $from
     * @param int $to
     * @return void
     */
    protected static function injectRange(&$array, int $from, int $to)
    {
        for ($i = $from; $i <= $to; $i++) {
            $array[] = $i;
        }
    }
}
