<?php
namespace Newland\NeosViewHelpers\ViewHelpers\Math;

/*
 * This file is part of the "neos-viewhelpers" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\FluidAdaptor\Core\ViewHelper\AbstractViewHelper;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;

/**
 * To hours view helper.
 *
 * Converts a given number to hours and minutes.
 */
class ToHoursViewHelper extends AbstractViewHelper
{

    public function initializeArguments(): void
    {
        $this->registerArgument('value', 'mixed', 'The value to render', false, null);
    }

    public static function renderStatic(
        array $arguments,
        \Closure $renderChildrenClosure,
        RenderingContextInterface $renderingContext
    ): string {
        $value = $arguments['value'] ?? $renderChildrenClosure();

        $hours = floor($value / 60);
        $minutes = ($value % 60);

        return sprintf('%02d:%02d', $hours, $minutes);
    }
}
