<?php
namespace Newland\NeosViewHelpers\ViewHelpers\Math;

/*
 * This file is part of the "neos-viewhelpers" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\FluidAdaptor\Core\ViewHelper\AbstractViewHelper;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;

/**
 * Round view helper.
 *
 * Rounds given input.
 */
class RoundViewHelper extends AbstractViewHelper
{
    public function initializeArguments(): void
    {
        $this->registerArgument('value', 'mixed', 'The value to round', false, null);
        $this->registerArgument('precision', 'integer', 'Number of digits after decimal point', false, 0);
    }

    public static function renderStatic(
        array $arguments,
        \Closure $renderChildrenClosure,
        RenderingContextInterface $renderingContext
    ): float {
        $value = $arguments['value'] ?? $renderChildrenClosure();
        return round((float) $value, $arguments['precision']);
    }
}
