<?php
namespace Newland\NeosViewHelpers\ViewHelpers\Math;

/*
 * This file is part of the "neos-viewhelpers" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\FluidAdaptor\Core\ViewHelper\AbstractViewHelper;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;

/**
 * Is not negative view helper.
 *
 * Checks if a given value is greater than '0'. This has been
 * implemented because fluid evaluates '0' as false.
 */
class IsNotNegativeViewHelper extends AbstractViewHelper
{
    public function initializeArguments(): void
    {
        $this->registerArgument('value', 'mixed', 'The value to check.', true);
    }

    public static function renderStatic(
        array $arguments,
        \Closure $renderChildrenClosure,
        RenderingContextInterface $renderingContext
    ): bool {
        return ($arguments['value'] !== null && $arguments['value'] >= 0);
    }
}
