<?php
namespace Newland\NeosViewHelpers\ViewHelpers\Math;

/*
 * This file is part of the "neos-viewhelpers" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\FluidAdaptor\Core\ViewHelper\AbstractViewHelper;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;

/**
 * Simple division viewhelper that was introduced because in certain circumstances the
 * fluid builtin division (using `{foo.bar / 1000}`) will throw an exception.
 *
 * @example
 * <vh:math.divide value="{foo.bar}" by="1000" />
 *
 * @example
 * {foo.bar -> vh:math.divide(by: 1000) -> vh:math.round(precision: 2)}
 */
class DivideViewHelper extends AbstractViewHelper
{

    public function initializeArguments(): void
    {
        $this->registerArgument('value', 'float', 'value to divide', false, null);
        $this->registerArgument('by', 'float', 'value to divide by', true);
    }

    public static function renderStatic(
        array $arguments,
        \Closure $renderChildrenClosure,
        RenderingContextInterface $renderingContext
    ): float {
        $value = $arguments['value'] ?? (float) $renderChildrenClosure();
        return $value / $arguments['by'];
    }
}
