<?php
namespace Newland\NeosViewHelpers\ViewHelpers\Format;

/*
 * This file is part of the "neos-viewhelpers" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\FluidAdaptor\Core\ViewHelper\AbstractViewHelper;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;

/**
 * Prefix format view helper.
 *
 * Set a prefix to a string.
 * A query can be used to compare the first characters of
 * the string and only set a prefix if they are different.
 *
 * @example
 * {format.link -> f:format.prefix(query: 'http', prefix: 'http://')}
 */
class PrefixViewHelper extends AbstractViewHelper
{

    public function initializeArguments(): void
    {
        $this->registerArgument('string', 'string', 'String that is modified', false, null);
        $this->registerArgument('query', 'string', 'Prefix which is checked for.', false, null);
        $this->registerArgument('prefix', 'string', 'Prefix to set if none is defined.', false, null);
    }

    public static function renderStatic(
        array $arguments,
        \Closure $renderChildrenClosure,
        RenderingContextInterface $renderingContext
    ): string {
        $string = $arguments['string'] ?? $renderChildrenClosure();
        $query = $arguments['query'];

        if ($query && substr($string, 0, strlen($query)) === $query) {
            return $string;
        }

        return $arguments['prefix'] . $string;
    }
}
