<?php
namespace Newland\NeosViewHelpers\ViewHelpers\Form;

/*
 * This file is part of the "neos-viewhelpers" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\FluidAdaptor\Core\ViewHelper\AbstractTagBasedViewHelper;

/**
 * Renders a simple honeypot. Use a fake but not too obviously fake name for maximum stickiness.
 *
 * @see https://stackoverflow.com/questions/36227376/better-honeypot-implementation-form-anti-spam
 */
class HoneypotViewHelper extends AbstractTagBasedViewHelper
{
    protected $tagName = 'input';

    public function initializeArguments(): void
    {
        $this->registerArgument('name', 'string', 'Name of the honeypot input', true);
    }

    public function render()
    {
        $this->tag->addAttributes(
            [
                'type' => 'checkbox',
                'name' => $this->arguments['name'],
                'value' => '1',
                'style' => 'display:none !important',
                'tabIndex' => '-1',
                'autocomplete' => 'off',
            ]
        );

        return $this->tag->render();
    }
}
