<?php
namespace Newland\NeosViewHelpers\ViewHelpers\Collection;

/*
 * This file is part of the "neos-viewhelpers" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Doctrine\ORM\PersistentCollection;
use Neos\FluidAdaptor\Core\ViewHelper\AbstractViewHelper;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;

/**
 * Slice view helper.
 *
 * Extracts a slice of a collection.
 */
class SliceViewHelper extends AbstractViewHelper
{

    public function initializeArguments(): void
    {
        $this->registerArgument('collection', 'mixed', null, true);
        $this->registerArgument('offset', 'integer', null, true);
        $this->registerArgument('length', 'integer', null, false, null);
    }

    public static function renderStatic(
        array $arguments,
        \Closure $renderChildrenClosure,
        RenderingContextInterface $renderingContext
    ): array {
        $collection = $arguments['collection'];
        if ($collection instanceof PersistentCollection) {
            $collection = $collection->getValues();
        }

        if (!is_array($collection)) {
            return [];
        }

        return array_slice($collection, $arguments['offset'], $arguments['length']);
    }
}
