<?php
namespace Newland\NeosViewHelpers\ViewHelpers\Collection;

use Neos\FluidAdaptor\Core\ViewHelper\AbstractViewHelper;
use TYPO3Fluid\Fluid\Core\Parser\SyntaxTree\ViewHelperNode;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;
use TYPO3Fluid\Fluid\Core\Variables\VariableProviderInterface;

class RangeViewHelper extends AbstractViewHelper
{

    public function initializeArguments(): void
    {
        $this->registerArgument('start', 'integer', 'Where to start the range', true);
        $this->registerArgument('end', 'integer', 'Where to end the range', true);
        $this->registerArgument('step', 'float', 'Step size', false, 1.0);
    }

    public static function renderStatic(
        array $arguments,
        \Closure $renderChildrenClosure,
        RenderingContextInterface $renderingContext
    ): array {
        return range($arguments['start'], $arguments['end'], $arguments['step']);
    }
}
