<?php
namespace Newland\NeosViewHelpers\ViewHelpers\Collection;

/*
 * This file is part of the "neos-viewhelpers" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\FluidAdaptor\Core\ViewHelper\AbstractViewHelper;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;

/**
 * Implode view helper.
 *
 * Implodes a collection.
 */
class ImplodeViewHelper extends AbstractViewHelper
{

    public function initializeArguments(): void
    {
        $this->registerArgument('glue', 'string', 'Character to use to implode the collection', true);
        $this->registerArgument('collection', 'string[]', 'Collection to glue together', false, null);
    }

    public static function renderStatic(
        array $arguments,
        \Closure $renderChildrenClosure,
        RenderingContextInterface $renderingContext
    ): string {
        if (!$arguments['collection']) {
            return '';
        }

        return implode($arguments['collection'], $arguments['glue']);
    }
}
