<?php
namespace Newland\NeosViewHelpers\Tests\Unit\ViewHelpers\Format;

use Newland\NeosViewHelpers\ViewHelpers\Format\PrefixViewHelper;
use PHPUnit\Framework\TestCase;

class PrefixViewHelperTest extends TestCase
{

    public function testStringIsTheSameIfNoPrefixIsDefined(): void
    {
        $this->assertSame((new PrefixViewHelper())->render('foobar', null, null), 'foobar');
        $this->assertSame((new PrefixViewHelper())->render('foobar', 'foo', null), 'foobar');
    }

    public function testStringChangesIfNoQueryIsDefined(): void
    {
        $this->assertSame((new PrefixViewHelper())->render('foobar', null, 'pre'), 'prefoobar');
    }

    public function testStringIsTheSameIfQueryExists(): void
    {
        $this->assertSame((new PrefixViewHelper())->render('foobar', 'foo', 'pre'), 'foobar');
    }

    public function testStringChangesIfQueryIsNotFound(): void
    {
        $this->assertSame((new PrefixViewHelper())->render('foobar', 'false', 'pre'), 'prefoobar');
    }

    public function testStringChangesIfQueryIsLongerThanString(): void
    {
        $this->assertSame((new PrefixViewHelper())->render('foobar', 'foobarbaz', 'pre'), 'prefoobar');
    }

    public function testEvaluatesChildrenIfNoStringGiven(): void
    {
        $called = false;
        $renderChildren = function() use (&$called) {
            $called = true;
        };

        $viewHelper = new PrefixViewHelper();
        $viewHelper->setRenderChildrenClosure($renderChildren);
        $viewHelper->render();

        $this->assertTrue($called, 'Children should have been rendered');
    }
}
