<?php declare(strict_types=1);
namespace Newland\NeosViewHelpers\ViewHelpers\Data;

/*
 * This file is part of the "neos-viewhelpers" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\FluidAdaptor\Core\ViewHelper\AbstractViewHelper;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;
use TYPO3Fluid\Fluid\Core\ViewHelper\Traits\CompileWithRenderStatic;

/**
 * Class JsonToTemplateVariables
 *
 * @package Newland\NeosViewHelpers\ViewHelpers\Data
 *
 * Example
 * <vh:data.jsonToTemplate json="{jsonData}">
 *   <span>{jsonKeyA}</span>
 *   <span>{jsonKeyB}</span>
 * </vh:data.jsonToTemplate>
 */
class JsonToTemplateVariablesViewHelper extends AbstractViewHelper
{
    use CompileWithRenderStatic;

    /**
     * @var boolean
     */
    protected $escapeOutput = false;

    /**
     * @return void
     */
    public function initializeArguments()
    {
        parent::initializeArguments();
        $this->registerArgument('json', 'string', 'The json encoded data', true);
    }

    public static function renderStatic(
        array $arguments,
        \Closure $renderChildrenClosure,
        RenderingContextInterface $renderingContext
    ) {
        $templateVariableContainer = $renderingContext->getVariableProvider();
        $data = json_decode($arguments['json'], true) ?: [];

        foreach ($data as $variable => $value) {
            $templateVariableContainer->add($variable, $value);
        }
        $output = $renderChildrenClosure();
        foreach ($data as $variable => $value) {
            $templateVariableContainer->remove($variable);
        }

        return $output;
    }
}
